## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include = FALSE---------------------------------------------------
library(ipaddress)

## -----------------------------------------------------------------------------
ip_address(c("192.168.0.1", "2001:db8::8a2e:370:7334"))

## -----------------------------------------------------------------------------
ip_address("255.255.255.256")

## -----------------------------------------------------------------------------
ip_network(c("192.168.0.0/24", "2001:db8::/48"))

## -----------------------------------------------------------------------------
ip_network("192.168.0.1/24")

ip_network("192.168.0.1/24", strict = FALSE)

## -----------------------------------------------------------------------------
ip_interface(c("192.168.0.1/10", "2001:db8:c3::abcd/45"))

## -----------------------------------------------------------------------------
x <- ip_interface(c("192.168.0.1/10", "2001:db8:c3::abcd/45"))

as_ip_address(x)

as_ip_network(x)

## ---- echo = FALSE, fig.cap="Summary of ipaddress classes"--------------------
knitr::include_graphics("ipaddress_classes.png")

