% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_transpose.R
\name{vector_transpose}
\alias{vector_transpose}
\title{Transpose a vector}
\usage{
vector_transpose(
  data_table,
  names_to = "nace_r2",
  values_to = "value",
  .keep = FALSE
)
}
\arguments{
\item{data_table}{A matrix or vector that should have a key column.}

\item{names_to}{Defaults to \code{'nace_r2'}.}

\item{values_to}{Defaults to \code{'value'}.}

\item{.keep}{Keep the indicator identifier column? Defaults to \code{FALSE}.}
}
\value{
A long form vector with a key column, and optionally the identifier of the indicator in
the first column.
}
\description{
Many vectors (indicators, multipliers) are create in the wide form to confom matrixes in 
analytical functions.  For printing it is more useful to have them in long form.
}
\details{
This is a wrapper around \code{\link[tidyr]{pivot_longer}} so you do not necessarily need to
import or load the entire \emph{tidyr} package.
}
\examples{
vector_transpose (
  data.frame(indicator = "my_inidcator", 
             agriculture = 0.0123,
             manufacturing = 0.1436,
             trade = 0.0921)
)
}
