% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_excl_inc.R
\encoding{utf-8}
\name{ind_excl_inc}
\alias{ind_excl_inc}
\title{Incrementally calls ind_excl_step}
\usage{
ind_excl_inc(indicators, outcome, indicatornames = 1:ncol(indicators),
  pcrit = 0.05, verbose = F, coruse = "everything")
}
\arguments{
\item{indicators}{Set of numeric indicators (items) in a matrix.}

\item{outcome}{A numeric outcome vector. Indicators and outcome can be simulated with
\code{\link{scale_sim}}}

\item{indicatornames}{An array of strings for labelling the outcome. Default to numbers
from 1 to n of indicators}

\item{pcrit}{a p-value characterising the ‘significance’ of difference between
correlations—here called ‘significance of indicator exclusion’ (SONE). Look it up
from Table 2 in Vainik, Mõttus et al 2015, or simulate using
 \code{\link{optimal_p}} function}

\item{verbose}{option for observing steps for debugging. Defaults to FALSE}

\item{coruse}{argument for function cor(). Defaults to 'everything', as
simulations have no missing data.}
}
\value{
Provides the results of a single step in indicator exclusion procedure. See example for details
}
\description{
See \code{\link{ind_excl}} for details.
}
\examples{
## Create a scale-outcome set that violates ION. Only 2 last indicators out of 8
## relate to the outcome, the others just relate to the 2 indicators
set.seed(466)
a<-scale_sim(n=2500, to_n=2, tn_n=6)
# run the exclusion procedure. Pcrit taken from Table 2 in Vainik et al., 2015,
# European Journal of Personality
res=ind_excl_inc(a[[1]],a[[2]], pcrit=0.0037)
# which indicators does the procedure exclude?
res

}

