% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_twofold_test.R
\name{twofold_test.pk}
\alias{twofold_test.pk}
\title{Evaluate whether data and predictions are within two-fold of mean or concentration, respectively}
\usage{
\method{twofold_test}{pk}(
  obj,
  sub_pLOQ = TRUE,
  suppress.messages = NULL,
  model = NULL,
  method = NULL,
  ...
)
}
\arguments{
\item{obj}{A pk object.}

\item{sub_pLOQ}{TRUE (default): Substitute all predictions below the LOQ with
the LOQ before computing fold errors. FALSE: do not. Only used if `obj` has been fitted and predictions are possible.}

\item{suppress.messages}{Logical: whether to suppress message printing. If
NULL (default), uses the setting in `obj$settings_preprocess$suppress.messages`.}

\item{model}{Optional: Specify one or more of the fitted models for which to
make predictions. If NULL (the default), predictions will be returned for
all of the models in `object$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
for which to make predictions. If NULL (the default), predictions will be
returned for all of the models in `object$settings_optimx$method`.}

\item{...}{Additional arguments. Currently unused.}
}
\value{
A list of data frames.
}
\description{
At each timepoint across CvT experimental data, there are three ways that data may
be presented. These can be found as either:
- multiple individual observations
- single individual observation
- summarized group of observations (mean concentration and standard deviation)
}
\details{
For the purposes of this calculations we largely divide the data into two groups,
those with individual observations, where N_Subjects == 1, and the summarized
group of observations.

First this creates mean-normalized concentrations for individual data.
Then it summarizes data (individual & summarized) by `mean` and `sd`.
It tests whether predictions are within two-fold of mean,
in the latter case whether the 95% of observations are within 2-fold.

Furthermore if `pk` object `status == 5` then it calculates the model error by
evaluating _prediction/concentration_ at each timepoint for all data. Each test
is done for data from individual subject observations and for all data by summarizing the
observations.

Only non-excluded detects are included in this analysis.
}
\author{
Gilberto Padilla Mercado
}
