% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateRawCosts.R, R/costTrendOverTime.R
\name{rawAvgCost-deprecated}
\alias{rawAvgCost-deprecated}
\title{Calculate the raw average annual cost over a single period of time}
\usage{
rawAvgCost(
  costdb,
  cost.column = "Cost_estimate_per_year_2017_USD_exchange_rate",
  year.column = "Impact_year",
  min.year = NULL,
  max.year = NULL
)

rawAvgCost(
  costdb,
  cost.column = "Cost_estimate_per_year_2017_USD_exchange_rate",
  year.column = "Impact_year",
  min.year = NULL,
  max.year = NULL
)
}
\arguments{
\item{min.year}{The minimum year of the period (specify only if different from
the range of data)}

\item{max.year}{The minimum year of the period (specify only if different from
the range of data)}

\item{costdb}{The \bold{expanded INVACOST database} output from 
\code{\link{expandYearlyCosts}},
where annual costs occurring over several years are repeated for each year.}

\item{cost.column}{Name of the cost column to use in \code{costdb} (usually, 
choose between the exchange rate (default) or PPP annualised cost)}

\item{year.column}{Name of the year column to use in \code{costdb}.}

\item{cost.transf}{Type of transformation you want to apply on cost values.
The default is a log10 transformation, which is commonly applied in economy,
allows to fit linear regression with a normal distribution of residuals, 
and makes plots easy to read. You can apply another transformation by 
specifying the name of the transformation function (e.g., natural
logarithm, {\code{"log"}}). Specify \code{NA} or \code{NULL} to avoid any 
transformation.}

\item{in.millions}{If \code{TRUE}, cost values will be transformed in 
millions (to make graphs easier to read), else if \code{}, cost values will
not be transformed.}

\item{confidence.interval}{a numeric value between 0 and 1, corresponding
to the desired confidence intervals around model predictions.}

\item{minimum.year}{the starting year of this analysis. By default, 
1960 was chosen because it marks the period from which world bank data is 
available for exchange rates and inflation values.}

\item{maximum.year}{the ending year for this analysis. By default, 2017
was chosen as it is the last year for which we have data in INVACOST.}

\item{final.year}{the year for which you want to obtain the final 
average cost estimate from models. Default is 2017.}

\item{incomplete.year.threshold}{Estimated threshold for incomplete cost 
data. All years above or equal to this threshold will be excluded from 
model calibration, because of the time-lag between economic impacts of
invasive species and the documentation and publication of these impacts.}

\item{incomplete.year.weights}{A named vector containing weights of years
for the regressions. Useful to decrease the weights of incomplete years
in regressions. Names of this vector must correspond to years.}

\item{gam.k}{The smoothing factor of GAM; default value of -1 will let the
GAM find the smoothing factor automatically. Provide a manual value if you 
have expectations about the shape of the curve and want to avoid overfitting
because of interannual variations.}

\item{mars.nprune}{The maximum number of model terms in the MARS model. 
Lowering this value will reduce the number of terms in the MARS model, which
can be useful if you have expectations about the shape of the curve and want
to avoid overfitting because of interannual variations.}

\item{...}{Other arguments (you do not need them!)}
}
\value{
a named \code{list} with 5 elements
\itemize{
 \item{\code{initial_year}: first year in the data}
 \item{\code{final_year}: last year in the data}
 \item{\code{time_span}: the difference between initial and final years.}
 \item{\code{total_cost}: total cost.}
 \item{\code{annual.cost}: cost per year}
 \item{\code{number_estimates}: the number of cost estimates before expansion 
via \code{\link{expandYearlyCosts}}
 \item{\code{number_year_values}: the number of yearly costs included}
}}

a \code{list} with 3 to 6 elements (only the first three will be 
provided if you selected a cost transformation different from log10):

\itemize{
\item{\code{cost.data}: the annualised costs of invasions, as sums of all 
costs for each year.}
\item{\code{parameters}: parameters used to run the function. The 
\code{minimum.year} and \code{maximum.year} are based on the input data
(i.e., the user may specify \code{minimum.year = 1960} but the input data may
only have data starting from 1970, hence the \code{minimum.year} will be
 1970.)}
\item{\code{fitted.models}: a list of objects the fitted models.}
\item{\code{estimated.annual.costs}: a data.frame containing the predicted 
cost values for each year for all the fitted models.}
\item{\code{RMSE}: an array containing RMSE of models for the calibration 
data and for all data. NOTE: the RMSE for quantile regression is not an 
relevant metric. }
\item{\code{final.year.cost}: a vector containing the estimated annual
costs of invasive species based on all models for \code{final.year}.}
}
The structure of this object can be seen using \code{str()}
}
\description{
This simple function calculates the raw average annual cost of invasive species
over a single period of time

This function fits different models on annualised INVACOST data in order to
estimate the average trend over time of invasive species costs.
}
\seealso{
\code{\link{invacost-deprecated}}

\code{\link{invacost-deprecated}}
}
\keyword{internal}
