% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_noreps.R
\name{design_noreps}
\alias{design_noreps}
\title{Experimental design without replications}
\usage{
design_noreps(
  factors,
  type = "sorted",
  zigzag = FALSE,
  nrows = NA,
  serie = 100,
  seed = NULL,
  fbname = "inkaverse",
  qrcode = "{fbname}{plots}{factors}"
)
}
\arguments{
\item{factors}{Lists with names and factor vector [list].}

\item{type}{Randomization in the list [string: sorted, unsorted]}

\item{zigzag}{Experiment layout in zigzag [logic: FALSE].}

\item{nrows}{Experimental design dimension by rows [numeric: value]}

\item{serie}{Number to start the plot id [numeric: 1000].}

\item{seed}{Replicability from randomization [numeric: NULL].}

\item{fbname}{Bar code prefix for data collection [string: "inkaverse"].}

\item{qrcode}{Concatenate the QR code [string: \{fbname\}\{plots\}\{factors\}]}
}
\value{
A list with the field-book design and parameters
}
\description{
Function to deploy field-book experiment without replications
}
\examples{

\dontrun{

library(inti)

factores <- list("geno" = c(1:99))

fb <- design_noreps(factors = factores
                     , type = "sorted"
                     , zigzag = F
                     , nrows = 10
                     )
                     
dsg <- fb$fieldbook

fb \%>\%   
  tarpuy_plotdesign(fill = "plots") 

fb$parameters

}
}
