% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TIA2csv.r
\name{TIA2csv}
\alias{TIA2csv}
\title{Output the result of transition level intensity analysis as csv.}
\usage{
TIA2csv(TIA.output, time.points, categories, filename)
}
\arguments{
\item{TIA.output}{Output list generated by \code{TIA} function.}

\item{time.points}{a charachter vector showing the time point of each raster layer in chronological order.}

\item{categories}{A charachter vector showing the categories in the map. Order of categories decided bases on the equivalent IDs in the raster attribute table.}

\item{filename}{A charachter variable including an optional path and a required filename to where the user wants to store the csv output. If only the name of the file is provided, it will be stored in the working directory.}
}
\value{
The output is a CSV file.
}
\description{
Output the result of transition level intensity analysis as csv.
}
\details{
Gets the output of \code{TIA} function and the path variable and generate a csv report called "TransitionLevelIntensityAnalysis.csv". The output will be stored in "CSVOutput" directory in the path direction.
}
\examples{
raster_2005 <- raster::raster(system.file("external/RASTER_2005.RST", package="intensity.analysis"))
raster_2010 <- raster::raster(system.file("external/RASTER_2010.RST", package="intensity.analysis"))
raster_2012 <- raster::raster(system.file("external/RASTER_2012.RST", package="intensity.analysis"))
raster.layers <- list(raster_2005, raster_2010, raster_2012)
time.points <- c("2005","2010","2012")
categories <- c("Water","Trees","Impervious")
crosstabulation <- multicrosstab(raster.layers, time.points, categories)
TIA.output <- TIA(crosstabulation, time.points, categories)
filename <- file.path(normalizePath(tempdir(), winslash = "/"), "TIA.csv")
TIA2csv(TIA.output,time.points,categories, filename)
}
