% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_mus.R
\name{compute_mus}
\alias{compute_mus}
\alias{print.mus}
\alias{plot.mus}
\title{Compute the ratio statistics needed for the intrinsic dimension estimation}
\usage{
compute_mus(X = NULL, dist_mat = NULL, n1 = 1, n2 = 2, Nq = FALSE, q = 3)

\method{print}{mus}(x, ...)

\method{plot}{mus}(x, range_d = NULL, ...)
}
\arguments{
\item{X}{a dataset with \code{n} observations and \code{D} variables.}

\item{dist_mat}{a distance matrix computed between \code{n} observations.}

\item{n1}{order of the first NN considered. Default is 1.}

\item{n2}{order of the second NN considered. Default is 2.}

\item{Nq}{logical indicator. If \code{TRUE}, it provides the \code{N^q} matrix
needed for fitting the Hidalgo model.}

\item{q}{integer, number of NN considered to build \code{N^q}.}

\item{x}{object of class \code{mus}, obtained from the
function \code{compute_mus()}.}

\item{...}{ignored.}

\item{range_d}{a sequence of values for which the generalized ratios density
is superimposed to the histogram of \code{mus}.}
}
\value{
a vector containing the ratio statistics, an object of class
\code{mus}. The length of the vector is equal to the number of observations
considered, unless ties are present in the dataset. In that case, the
duplicates are removed. Optionally, if \code{Nq} is \code{TRUE}, the function
returns a list containing both the ratio statistics and the adjacency
matrix \code{N^q}.
}
\description{
The function \code{compute_mus} computes the ratios of distances between
nearest neighbors (NNs) of generic order, denoted as
\code{mu(n_1,n_2)}.
This quantity is at the core of all the likelihood-based methods contained
in the package.
}
\examples{
X           <- replicate(2,rnorm(1000))
mu          <- compute_mus(X, n1 = 1, n2 = 2)
mudots      <- compute_mus(X, n1 = 4, n2 = 8)
pre_hidalgo <- compute_mus(X, n1 = 4, n2 = 8, Nq = TRUE, q = 3)
}
\references{
Facco E, D'Errico M, Rodriguez A, Laio A (2017). "Estimating the intrinsic
dimension of datasets by a minimal neighborhood information."
Scientific Reports, 7(1), 1-8.
ISSN 20452322, doi: 10.1038/s41598-017-11873-y.

Denti F, Doimo D, Laio A, Mira A (2022+). "Distributional Results for
Model-Based Intrinsic Dimension Estimators."
arXiv preprint. 2104.13832, \url{https://arxiv.org/abs/2104.13832}.
}
