% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_factors.R
\name{rating_factors1}
\alias{rating_factors1}
\title{Include reference group in regression output}
\usage{
rating_factors1(
  model,
  model_data = NULL,
  exposure = NULL,
  colname = "estimate",
  exponentiate = TRUE,
  round_exposure = 0
)
}
\arguments{
\item{model}{a single glm object produced by \code{glm()}}

\item{model_data}{data.frame used to create glm object, this should only
be specified in case the exposure is desired in the output, default
value is NULL}

\item{exposure}{the name of the exposure column in \code{model_data},
default value is NULL}

\item{colname}{the name of the output column, default value is "estimate"}

\item{exponentiate}{logical indicating whether or not to exponentiate
the coefficient estimates. Defaults to TRUE.}

\item{round_exposure}{number of digits for exposure (default to 0)}
}
\description{
Extract coefficients in terms of the original levels of the
coefficients rather than the coded variables.Use rating_factors() to
compare the output obtained from two or more glm objects.
}
\examples{
MTPL2a <- MTPL2
MTPL2a$area <- as.factor(MTPL2a$area)
x <- glm(nclaims ~ area, offset = log(exposure), family = poisson(), data = MTPL2a)
rating_factors1(x)

}
\author{
Martin Haringa
}
