\name{copy.packages.between.libraries}
\alias{copy.packages.between.libraries}
\title{Copies all packages from one library folder to another}
\usage{
  copy.packages.between.libraries(from, to, ask = FALSE,
    keep_old = TRUE,
    do_NOT_override_packages_in_new_R = TRUE)
}
\arguments{
  \item{from}{a character vector for the location of the
  old library folder FROM which to copy files from.}

  \item{to}{a character vector for the location of the old
  library folder TO which to copy files to.}

  \item{ask}{should the user be given the option to choose
  between which two libraries to copy the packages?  If
  FALSE (default), the folders are copied from the
  before-newest R installation to the newest R
  installation.  This the overrides "from" and "to"
  parameters.}

  \item{keep_old}{should the packages be COPIED to the new
  library folder, thus KEEPing the old package as they are?
  Or should they be removed?}

  \item{do_NOT_override_packages_in_new_R}{default TRUE If
  FALSE, then If a package exists in both the "from" and
  "to" library folders - it would copy to "to" the version
  of the package from "from". (this parameter should rarely
  be FALSE)}
}
\value{
  TRUE if it copied (moved) packages, and FALSE if it did
  not.
}
\description{
  Copies all packages from one folder to another.  This
  function is used if we wish to either: \itemize{ \item
  Upgrade R to a new version - and copy all of the packages
  from the old R installation to the new one. \item Move to
  a global library system - and wanting to copy all of
  packages from the local library folder to the global one
  } It takes into account that we don't want to copy
  packages which have "high" importance (such as MASS,
  boot, graphics, utils, rpart, Matrix and more GREAT
  packages...) to the new library folder. Also, it assumes
  that within an R installation, the packages are located
  inside the "library" folder.
}
\examples{
\dontrun{
copy.packages.between.libraries(ask = T)
# it will ask you from what R version
# to copy the packages into which R version.
# Since (do_NOT_override_packages_in_new_R = T) the function will
# make sure to NOT override your newer packages.

# copy.packages.between.libraries(ask = T, keep_old = F)
# As before, but this time it will MOVE (instead of COPY) the packages.
#  e.g: erase them from their old location.
}
}
\seealso{
  \link{get.installed.R.folders}
}

