% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_insee_title.R
\name{add_insee_title}
\alias{add_insee_title}
\title{Add a title column to the idbank list dataset}
\usage{
add_insee_title(df, n_split, lang = "en", split = TRUE, clean = TRUE)
}
\arguments{
\item{df}{a dataframe containing an idbank column called "idbank" or "IDBANK"}

\item{n_split}{number of new columns, by default the maximum is chosen}

\item{lang}{returns an English title, by default is "en", any other value returns a French title}

\item{split}{split the title column in several columns, by default is TRUE}

\item{clean}{remove the columns filled with NA (missing value), by default is TRUE}
}
\value{
the same dataframe but with one or several title columns
}
\description{
Add a title column to the idbank list dataset
}
\details{
this function uses extensively the get_insee_title function.
Then, it should be used on an already filtered dataset, not on the full idbank dataset (cf. get_insee_title).
The number of separators in the official INSEE title can vary and is not normalized. Beware all title columns created may not be a cleaned dimension label.
}
\examples{
\donttest{
library(tidyverse)

idbank_list = get_idbank_list() #idbank list

idbank_empl = idbank_list \%>\%
 filter(nomflow == "EMPLOI-SALARIE-TRIM-NATIONAL") \%>\% #employment
 slice(1:15) \%>\%
 add_insee_title()
}
}
