% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write}
\alias{write}
\alias{writeFASTQ}
\alias{writeFASTA}
\title{Write sequences to text in FASTA or FASTQ format.}
\usage{
writeFASTQ(x, file = "", compress = FALSE, append = FALSE)

writeFASTA(x, file = "", compress = FALSE, append = FALSE, wrap = NULL)
}
\arguments{
\item{x}{a list of sequences in \code{DNAbin} or \code{AAbin} format, or a
vector of sequences as concatenated upper-case character strings.
For writeFASTQ, only DNAbin objects are accepted, and each element should have
a vector of quality scores of equal length attributed to the sequence.
These vectors are comprised of raw bytes ranging from 00 to 5d
(0 to 93 when converted to integers).
See \code{\link{readFASTQ}} for more details.}

\item{file}{character string giving a valid file path to output the text to.
If file = "" (default setting) the text file is written to the
console.}

\item{compress}{logical indicating whether the output file should be gzipped.}

\item{append}{logical indicating whether the output should be appended to the file.}

\item{wrap}{integer giving the maximum number of characters on each sequence line.
Defaults to NULL (no wrapping).}
}
\value{
NULL (invisibly).
}
\description{
These functions take a list of DNA or amino acid sequences in
  \code{DNAbin} or \code{AAbin} format
  and outputs a text file to a specified directory.
}
\examples{
\donttest{
  ## download and extract example FASTQ file to temporary directory
  td <- tempdir()
  URL <- "https://www.dropbox.com/s/71ixehy8e51etdd/insect_tutorial1_files.zip?dl=1"
  dest <- paste0(td, "/insect_tutorial1_files.zip")
  download.file(URL, destfile = dest, mode = "wb")
  unzip(dest, exdir = td)
  x <- readFASTQ(paste0(td, "/COI_sample2.fastq"))
  ## trim primers from sequences
  mlCOIintF <- "GGWACWGGWTGAACWGTWTAYCCYCC"
  jgHCO2198 <- "TAIACYTCIGGRTGICCRAARAAYCA"
  x <- trim(x, up = mlCOIintF, down = jgHCO2198)
  ## quality filter with size selection and singleton removal
  x <- qfilter(x, minlength = 250, maxlength = 350)
  ## output filtered FASTQ file
  writeFASTQ(x, file = paste0(td, "/COI_sample2_filtered.fastq"))
  writeFASTA(x, file = paste0(td, "/COI_sample2_filtered.fasta"))
 }
}
\references{
Illumina help page:
  \url{https://help.basespace.illumina.com/articles/descriptive/fastq-files/}
}
\seealso{
\code{\link{readFASTQ}} for reading FASTQ files into R,
  and \code{\link[ape]{write.dna}} in the ape package
  for writing DNA to text in FASTA and other formats.
}
\author{
Shaun Wilkinson
}
