% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualPCR.R
\name{virtualPCR}
\alias{virtualPCR}
\title{Virtual PCR.}
\usage{
virtualPCR(x, up, down = NULL, rcdown = TRUE, trimprimers = FALSE,
  minfsc = 50, minrsc = 50, minamplen = 50, maxamplen = 2000,
  maxNs = 0.02, partialbind = TRUE, cores = 1, quiet = FALSE)
}
\arguments{
\item{x}{a list of DNA sequences in \code{DNAbin} format.}

\item{up}{an object of class \code{DNAbin} or \code{PHMM} giving the
forward primer with which to query the sequence list.}

\item{down}{an optional argument the same type as \code{up} giving the
reverse primer with which to query the sequence list. If NULL only
the forward primer is used.}

\item{rcdown}{logical indicating whether the reverse primer should be
reverse-complemented prior to aligning with the input sequences. Set
to TRUE only if \code{down} is not NULL, is of class \code{DNAbin}, and
is the reverse complement of the target sequence (e.g. the sequence of
a reverse primer as would be ordered from an oligo supplier).}

\item{trimprimers}{logical indicating whether the primer-binding sites
should be removed from the sequences in the returned list.}

\item{minfsc}{numeric, giving the minimum specificity(log-odds score
for the optimal alignment) between the forward primer and a sequence
for that sequence to be retained.}

\item{minrsc}{numeric, the minimum specificity (log-odds score for
the optimal alignment) between the reverse primer (if provided) and
a sequence for that sequence to be retained.}

\item{minamplen, maxamplen}{integers giving the minimum and maximum
acceptable amplicon lengths. Sequences are discarded if the number
of base pairs between the primer-binding sites falls outside of these
limits.}

\item{maxNs}{numeric giving the maximum acceptable proportion
of the ambiguous residue "N" within the output sequences.
Defaults to 0.02.}

\item{partialbind}{logical indicating whether partial primer matching is
accepted. Defaults to TRUE.}

\item{cores}{integer giving the number of CPUs to parallelize the operation
over. Defaults to 1, and reverts to 1 if x is not a list.
This argument may alternatively be a 'cluster' object,
in which case it is the user's responsibility to close the socket
connection at the conclusion of the operation,
for example by running \code{parallel::stopCluster(cores)}.
The string 'autodetect' is also accepted, in which case the maximum
number of cores to use is one less than the total number of cores available.
Note that in this case there
may be a tradeoff in terms of speed depending on the number and size
of sequences to be processed, due to the extra time required to initialize
the cluster.}

\item{quiet}{logical indicating whether progress should be printed to
the console.}
}
\value{
a list of trimmed sequences, an object of class
  \code{DNAbin}.
}
\description{
\code{virtualPCR} queries a list of DNA sequences with virtual primers
  (either sequences or profile hidden Markov models) and returns only
  the sequences that contain regions of sufficient similarity based on
  log-odds alignment scoring.
}
\examples{
  ## trim whale sequences using a new set of inner primers
  inner_for <- "CGGTTGGGGTGACCTCGGAGTA"
  inner_rev <- "GCTGTTATCCCTAGGGTAA"
  whales_short <- virtualPCR(whales, up = inner_for, down = inner_rev,
                             trimprimers = TRUE)
}
\author{
Shaun Wilkinson
}
