% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.R
\name{gmap}
\alias{gmap}
\title{Plot a map using extend of a spatial object}
\usage{
gmap(data, ...)
}
\arguments{
\item{data}{A Spatial* object.}

\item{...}{Arguments passed on to get_map().}
}
\value{
a ggplot object
}
\description{
Uses get_map() to query map services like Google Maps for a region centered around
the spatial object provided. Then calls ggmap() to plot the map.
}
\details{
This function requires the `ggmap` package.
}
\examples{
\donttest{
# Load the Gorilla data
data(gorillas, package = "inlabru")
 
# Create a base map centered around the nests and plot the boundary as well as the nests
gmap(gorillas$nests, maptype = "satellite") + 
    gm(gorillas$boundary) + 
    gm(gorillas$nests, color = "white", size = 0.5)
 
}
}
