% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{infuse}
\alias{infuse}
\title{Infuse a template with values.}
\usage{
infuse(file_or_string, ...,
  variable_identifier = getOption("variable_identifier"),
  default_char = "|", collapse_char = ",",
  transform_function = function(value) return(value),
  verbose = getOption("verbose"), simple_character = FALSE)
}
\arguments{
\item{file_or_string}{the template file or a character string containing the template}

\item{...}{different keys with related values, used to fill in the template (if first passed item is a list/environment the contents of this will be processed instead)}

\item{variable_identifier}{the opening and closing character that denounce a variable in the template, defaults to \code{c("{{", "}}")} and can be set persistently using e.g. \code{options(variable_identifier=c("{{", "}}"))}}

\item{default_char}{the character use to specify a default after}

\item{collapse_char}{the character used to collapse a supplied vector}

\item{transform_function}{a function through which all specified values are passed, can be used to make inputs safe(r).  dplyr::build_sql is a good default for SQL templating.}

\item{verbose}{verbosity level}

\item{simple_character}{if \code{TRUE} returns only a character vector, else adds the \code{infuser} class to the returned object.}
}
\description{
For more info and usage examples see the README on the \href{https://github.com/Bart6114/infuser}{\code{infuser} github page}.
To help prevent \href{https://xkcd.com/327/}{SQL injection attacks} (or other injection attacks), use a transformation function to escape special characters and provide it through the \code{transform_function} argument. \code{\link[dplyr]{build_sql}} is a great default escaping function for SQL templating.  For templating in other languages you will need to build/specify your own escaping function.
}
