% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFixedEF.twoPhase.R
\name{getFixedEF.twoPhase}
\alias{getFixedEF.twoPhase}
\title{Get the Fixed Components' coefficients and Efficiency Factors of
Two-Phase Experiments.}
\usage{
getFixedEF.twoPhase(effFactors, trt.Sca, T, Rep, table.legend, decimal, digits,
  list.sep)
}
\arguments{
\item{effFactors}{a list of numeric vector generated by
\code{\link{getEffFactor}} function.}

\item{trt.Sca}{a numeric vector generated by \code{\link{getTrtRep}}
function.}

\item{T}{a list of matrices generated by \code{\link{makeContrMat}}
function.}

\item{Rep}{a numeric matrix generated by \code{\link{getTrtRep}} function.}

\item{table.legend}{a logical allows users to generate a legend for the
variance components of the ANOVA table for large designs. Default is
\code{FALSE}, resulting in the use of original treatment factor names.}

\item{decimal}{a logical allows users to display the coefficients as the
decimals. Default is \code{FALSE}, resulting in the use of
\code{fractions}.}

\item{digits}{a integer indicating the number of decimal places. Default is
2, resulting in 2 decimal places.}

\item{list.sep}{a logical allows users to present the efficiency factors
and coefficients of the fixed effects a list of separate matrices.}
}
\value{
A matrix.
}
\description{
Calculate coefficients of fixed effects components of EMS and Treatment
Efficiency Factors within each stratum in Single-Phase or two-phase
experiment.
}
\details{
Constructs a matrix containing the coefficients of the coefficients of
fixed effects components of EMS within each stratum. Also calculates and
the average efficiency factors of each treatment effect across all strata

Construct a matrix contain the coefficients of the fixed Components and the
average efficiency factors of single-phase experiments.

The function uses the efficiency factors generated by \code{getEffFactor}
to calculated the coefficients of fixed Effects components of EMS and
insert the treatment efficiency factor within each stratum.

The complication arise in giving the row names of the matrix for the source
of variation in the ANOVA table.
}
\author{
Kevin Chang
}
