% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simulate_sparse_matrix}
\alias{simulate_sparse_matrix}
\title{Generate a simulated sparse matrix for single-cell data testing}
\usage{
simulate_sparse_matrix(
  nrow,
  ncol,
  density = 0.1,
  distribution_fun = function(n) stats::rpois(n, lambda = 0.5) + 1,
  seed = 1
)
}
\arguments{
\item{nrow}{Number of rows (genes) in the matrix.}

\item{ncol}{Number of columns (cells) in the matrix.}

\item{density}{Density of non-zero elements (default: 0.1, representing 90 sparsity).}

\item{distribution_fun}{Function to generate non-zero values.}

\item{seed}{Random seed for reproducibility.}
}
\value{
A sparse matrix of class "dgCMatrix"
}
\description{
Generate a simulated sparse matrix for single-cell data testing
}
\examples{
simulate_sparse_matrix(2000, 500) |>
  check_sparsity()
}
