% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matrix_to_table}
\alias{matrix_to_table}
\title{Switch matrix to network table}
\usage{
matrix_to_table(
  network_matrix,
  regulators = NULL,
  targets = NULL,
  threshold = 0
)
}
\arguments{
\item{network_matrix}{The matrix of network weight.}

\item{regulators}{Character vector of regulator names to filter by.}

\item{targets}{Character vector of target names to filter by.}

\item{threshold}{The threshold for filtering weights based on absolute values, defaults to 0.}
}
\value{
Network table
}
\description{
Switch matrix to network table
}
\examples{
data("example_matrix")
network_table <- inferCSN(example_matrix)
network_matrix <- table_to_matrix(network_table)
network_table_new <- matrix_to_table(network_matrix)
head(network_table)
head(network_table_new)
identical(
  network_table,
  network_table_new
)

matrix_to_table(
  network_matrix,
  threshold = 0.8
)

matrix_to_table(
  network_matrix,
  regulators = c("g1", "g2"),
  targets = c("g3", "g4")
)

}
