% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.regression.R
\name{single.network}
\alias{single.network}
\title{Construct network for single gene}
\usage{
single.network(
  matrix,
  regulators,
  target,
  cross_validation = FALSE,
  seed = 1,
  penalty = "L0",
  algorithm = "CD",
  regulators_num = (ncol(matrix) - 1),
  n_folds = 10,
  percent_samples = 1,
  r_threshold = 0,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{matrix}{An expression matrix, cells by genes.}

\item{regulators}{A character vector with the regulators to consider for CSN inference.}

\item{target}{Target gene.}

\item{cross_validation}{Check whether cross validation is used.}

\item{seed}{The seed used in randomly shuffling the data for cross-validation.}

\item{penalty}{The type of regularization.
This can take either one of the following choices: \code{L0} and \code{L0L2}.
For high-dimensional and sparse data, such as single-cell sequencing data, \code{L0L2} is more effective.}

\item{algorithm}{The type of algorithm used to minimize the objective function.
Currently \code{CD} and \code{CDPSI} are supported.
The \code{CDPSI} algorithm may yield better results, but it also increases running time.}

\item{regulators_num}{The number of non-zore coefficients, this value will affect the final performance.
The maximum support size at which to terminate the regularization path.
Recommend setting this to a small fraction of min(n,p) (e.g. 0.05 * min(n,p)) as L0 regularization typically selects a small portion of non-zeros.}

\item{n_folds}{The number of folds for cross-validation.}

\item{percent_samples}{The percent of all samples used for \code{\link{sparse.regression}}. Default set to 1.}

\item{r_threshold}{Threshold of \eqn{R^2} or correlation coefficient.}

\item{verbose}{Print detailed information.}

\item{...}{Parameters for other methods.}
}
\value{
The weight data table of sub-network
}
\description{
Construct network for single gene
}
\examples{
data("example_matrix")
single_network <- single.network(
  example_matrix,
  regulators = colnames(example_matrix),
  target = "g1"
)
head(single_network)

single.network(
  example_matrix,
  regulators = "g1",
  target = "g2"
)
}
