% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shade_p_value.R
\name{shade_p_value}
\alias{shade_p_value}
\alias{shade_pvalue}
\title{Shade histogram area beyond an observed statistic}
\usage{
shade_p_value(obs_stat, direction, color = "red2", fill = "pink", ...)

shade_pvalue(obs_stat, direction, color = "red2", fill = "pink", ...)
}
\arguments{
\item{obs_stat}{The observed statistic or estimate. For
\code{\link[=calculate]{calculate()}}-based workflows, this will be a 1-element numeric vector or
a \verb{1 x 1} data frame containing the observed statistic.
For \code{\link[=fit.infer]{fit()}}-based workflows, a \verb{(p + 1) x 2} data frame
with columns \code{term} and \code{estimate} giving the observed estimate for
each term.}

\item{direction}{A string specifying in which direction the shading should
occur. Options are \code{"less"}, \code{"greater"}, or \code{"two-sided"}. Can
also give \code{"left"}, \code{"right"}, \code{"both"}, \code{"two_sided"}, \code{"two sided"},
or \code{"two.sided"}. If \code{NULL}, the function will not shade any area.}

\item{color}{A character or hex string specifying the color of the observed
statistic as a vertical line on the plot.}

\item{fill}{A character or hex string specifying the color to shade the
p-value region. If \code{NULL}, the function will not shade any area.}

\item{...}{Other arguments passed along to \\{ggplot2\\} functions.
For expert use only.}
}
\value{
If added to an existing {infer} visualization, a \\{ggplot2\\}
object displaying the supplied statistic on top of its corresponding
distribution. Otherwise, an \code{infer_layer} list.
}
\description{
\code{shade_p_value()} plots a p-value region on top of
\code{\link[=visualize]{visualize()}} output. The output is a ggplot2 layer that can be added with
\code{+}. The function has a shorter alias, \code{shade_pvalue()}.

Learn more in \code{vignette("infer")}.
}
\examples{
# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  hypothesize(null = "point", mu = 40) \%>\%
  calculate(stat = "t")
  
# ...and a null distribution
null_dist <- gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 1000, type = "bootstrap") \%>\%
  # estimating the null distribution
  calculate(stat = "t")
  
# shade the p-value of the point estimate
null_dist \%>\%
  visualize() +
  shade_p_value(obs_stat = point_estimate, direction = "two-sided")
  
# you can shade confidence intervals on top of
# theoretical distributions, too!
null_dist_theory <- gss \%>\%
  specify(response = hours) \%>\%
  assume(distribution = "t") 
  
null_dist_theory \%>\%
  visualize() +
  shade_p_value(obs_stat = point_estimate, direction = "two-sided")

\donttest{
# to visualize distributions of coefficients for multiple
# explanatory variables, use a `fit()`-based workflow

# fit 1000 linear models with the `hours` variable permuted
null_fits <- gss \%>\%
 specify(hours ~ age + college) \%>\%
 hypothesize(null = "independence") \%>\%
 generate(reps = 1000, type = "permute") \%>\%
 fit()
 
null_fits

# fit a linear model to the observed data
obs_fit <- gss \%>\%
  specify(hours ~ age + college) \%>\%
  fit()

obs_fit

# visualize distributions of coefficients 
# generated under the null
visualize(null_fits)

# add a p-value shading layer to juxtapose the null 
# fits with the observed fit for each term
visualize(null_fits) + 
  shade_p_value(obs_fit, direction = "both")

# the direction argument will be applied 
# to the plot for each term
visualize(null_fits) + 
  shade_p_value(obs_fit, direction = "left")
}

# more in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
}

}
\seealso{
Other visualization functions: 
\code{\link{shade_confidence_interval}()}
}
\concept{visualization functions}
