% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_p_value.R
\name{get_p_value}
\alias{get_p_value}
\alias{get_pvalue}
\title{Compute p-value}
\usage{
get_p_value(x, obs_stat, direction)

get_pvalue(x, obs_stat, direction)
}
\arguments{
\item{x}{Data frame of calculated statistics as returned by \code{\link[=generate]{generate()}}}

\item{obs_stat}{A numeric value or a 1x1 data frame (as extreme or more
extreme than this).}

\item{direction}{A character string. Options are \code{"less"}, \code{"greater"}, or
\code{"two-sided"}. Can also use \code{"left"}, \code{"right"}, \code{"both"},
\code{"two_sided"}, or \code{"two sided"}.}
}
\value{
A 1x1 \link[tibble:tibble]{tibble} with value between 0 and 1.
}
\description{
Compute a p-value from a null distribution and observed statistic.
Simulation-based methods are (currently only) supported.

Learn more in \code{vignette("infer")}.
}
\section{Aliases}{

\code{get_pvalue()} is an alias of \code{get_p_value()}.
\code{p_value} is a deprecated alias of \code{get_p_value()}.
}

\section{Zero p-value}{

Though a true p-value of 0 is impossible, \code{get_p_value()} may return 0 in
some cases. This is due to the simulation-based nature of the \{infer\}
package; the output of this function is an approximation based on
the number of \code{reps} chosen in the \code{generate()} step. When the observed
statistic is very unlikely given the null hypothesis, and only a small
number of \code{reps} have been generated to form a null distribution,
it is possible that the observed statistic will be more extreme than
every test statistic generated to form the null distribution, resulting
in an approximate p-value of 0. In this case, the true p-value is a small
value likely less than \code{3/reps} (based on a poisson approximation).

In the case that a p-value of zero is reported, a warning message will be
raised to caution the user against reporting a p-value exactly equal to 0.
}

\examples{

# find the point estimate---mean number of hours worked per week
point_estimate <- gss \%>\%
  specify(response = hours) \%>\%
  calculate(stat = "mean") \%>\%
  dplyr::pull()

# starting with the gss dataset
gss \%>\%
  # ...we're interested in the number of hours worked per week
  specify(response = hours) \%>\%
  # hypothesizing that the mean is 40
  hypothesize(null = "point", mu = 40) \%>\%
  # generating data points for a null distribution
  generate(reps = 1000, type = "bootstrap") \%>\%
  # finding the null distribution
  calculate(stat = "mean") \%>\%
  get_p_value(obs_stat = point_estimate, direction = "two-sided")
  
# More in-depth explanation of how to use the infer package
\dontrun{
vignette("infer")
}  
  
}
