% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{t_test}
\alias{t_test}
\title{Tidy t-test}
\usage{
t_test(data, formula, order = NULL, alternative = "two_sided",
  mu = 0, conf_int = TRUE, conf_level = 0.95, ...)
}
\arguments{
\item{data}{A data frame that can be coerced into a \link[tibble:tibble]{tibble}.}

\item{formula}{A formula with the response variable on the left and the
explanatory on the right.}

\item{order}{A string vector of specifying the order in which the levels of
the explanatory variable should be ordered for subtraction, where \code{order = c("first", "second")} means \code{("first" - "second")}.}

\item{alternative}{Character string giving the direction of the alternative
hypothesis. Options are \code{"two_sided"} (default), \code{"greater"}, or \code{"less"}.}

\item{mu}{A numeric value giving the hypothesized null mean value for a one
sample test and the hypothesized difference for a two sample test.}

\item{conf_int}{A logical value for whether to include the confidence
interval or not. \code{TRUE} by default.}

\item{conf_level}{A numeric value between 0 and 1. Default value is 0.95.}

\item{...}{For passing in other arguments to \link[stats:t.test]{t.test()}.}
}
\description{
A tidier version of \link[stats:t.test]{t.test()} for two sample tests.
}
\examples{
# t test for comparing mpg against automatic/manual
mtcars \%>\%
  dplyr::mutate(am = factor(am)) \%>\%
  t_test(mpg ~ am, order = c("1", "0"), alternative = "less")

}
