\name{plot.theorLc}
\alias{plot.theorLc}
\alias{lines.theorLc}
\title{Plot Theoretical Lorenz Curves}
\description{
 Plotting method for objects of class \code{"theorLc"} (theoretical Lorenz
curves)}
\usage{
\method{plot}{theorLc}(x, parameter=NULL, xlab="p", ylab="L(p)", lwd=2, las=1, ...)
}
\arguments{
 \item{x}{an object of class \code{"theorLc"}}
 \item{parameter}{vector containing parameters of the distributions. If \code{x}
  was generated by the function \code{\link{theorLc}} the parameters are already
  fixed and have to be set to \code{NULL}.}
 \item{xlab, ylab, lwd, las, ...}{high-level \code{\link{plot}} function parameters.}
}
\references{C Dagum: Income Distribution Models, 1983, in: Johnson / Kotz (Eds): Encyclopedia of Statistical Sciences Vol.4, 27-34.

J B McDonald: Some generalized functions for the size distribution of income, 1984, Econometrica 52, 647-664.}
\author{Achim Zeileis \email{zeileis@ci.tuwien.ac.at}}

\seealso{\code{\link{Lc}}, \code{\link{plot.Lc}}}

\examples{
# income distribution of the USA in 1968 (in 10 classes)
# x vector of class means, n vector of class frequencies
x <- c(541, 1463, 2445, 3438, 4437, 5401, 6392, 8304, 11904, 22261)
n <- c(482, 825, 722, 690, 661, 760, 745, 2140, 1911, 1024)

# compute minimal Lorenz curve (= no inequality in each group)
Lc.min <- Lc(x, n=n)
# compute maximal Lorenz curve (limits of Mehran)
Lc.max <- Lc.mehran(x,n)
# plot both Lorenz curves in one plot
plot(Lc.min)
lines(Lc.max, col=4)

# add the theoretic Lorenz curve of a Lognormal-distribution with variance 0.78
lines(Lc.lognorm, parameter=0.78)
# add the theoretic Lorenz curve of a Dagum-distribution
lines(Lc.dagum, parameter=c(3.4,2.6))
}
\keyword{hplot}

