% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printing.R
\name{print.incidence2}
\alias{print.incidence2}
\title{Print an incidence object.}
\usage{
\method{print}{incidence2}(x, ...)
}
\arguments{
\item{x}{\verb{<incidence2>} object.}

\item{...}{Additional arguments passed through to \code{pillar::tbl_format_setup()}.}
}
\description{
Printing of \verb{<incidence2>} objects is handled via the \pkg{pillar} package.
}
\examples{
if (requireNamespace("outbreaks", quietly = TRUE)) {
\dontshow{withAutoprint(\{}
    data(ebola_sim_clean, package = "outbreaks")
    dat <- ebola_sim_clean$linelist

    (out <- incidence(dat, "date_of_onset"))

    # use `n` to print more lines
    print(out, n = 20L)
\dontshow{\})}
}

}
