% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_counts.R
\name{complete_counts}
\alias{complete_counts}
\title{Complete counts for all date and group combinations}
\usage{
complete_counts(x, fill = 0L)
}
\arguments{
\item{x}{An \code{\link[=incidence]{incidence()}} object.}

\item{fill}{The value to replace missing counts by. Defaults to \code{0L}.}
}
\description{
This function ensures that an incidence object has the same range of dates
for each grouping. By default missing counts will be filled with \code{0L}.
}
\examples{
dat <- data.frame(
  dates = Sys.Date() + 1:4,
  groups = rep(c("grp1","grp2"), 2),
  counts = 1:4
)

i <- incidence(dat, date_index = dates, groups = groups, counts = counts)
complete_counts(i)

}
