% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incRenv_old.R
\name{incRenv_old}
\alias{incRenv_old}
\title{Matching environmental and nest temperatures - Old version}
\usage{
incRenv_old(
  data.nest,
  data.env,
  env.temperature.name,
  env.date.name,
  env.date.format,
  env.timezone
)
}
\arguments{
\item{data.nest}{data frame containing nest temperature recordings. It must have two compulsory
columns 'date' and 'hour' displaying dates and the hour of each observation. These two columns
are provided if the user uses \code{\link{incRprep}} before.}

\item{data.env}{data frame containing environmental temperatures to be merged with nest temperature
records. Please, provide date and time of each observation in one unique column as requested 
for \code{\link{incRprep}}.}

\item{env.temperature.name}{name of the column containing temperature recordings in the 
\emph{data.env} data frame.}

\item{env.date.name}{name of the column containing date and time in the 
\emph{data.env} data frame.}

\item{env.date.format}{format of \emph{env.date.name}. Similar to \code{\link{incRprep}}.}

\item{env.timezone}{time zone of the environmental recordings. Similar to \code{\link{incRprep}}.}
}
\value{
The original \emph{data.nest} with an additional column for hour-averaged environmental
temperature. This new variable is thought to serve as \emph{env_temp} in
\code{\link{incRscan}}.
}
\description{
This function takes a data frame with recordings of environmental temperature and another
with nest temperatures and merges both per unit of time. The user can do this work manually, however, 
\code{\link{incRenv}} is thought to
automate data preparation (in combination with \code{\link{incRprep}}) to use 
\code{\link{incRscan}} after.
}
\details{
This function is thought to be used after \code{\link{incRprep}} as it uses some of the
additional variables created by \code{\link{incRprep}}.
}
\examples{
data(incR_envdata)  # environmental data
head (incR_envdata)

data(incR_rawdata)  # loading nest data
head (incR_rawdata)

# the first step in to format the raw data using incRprep
new.data <- incRprep (data=incR_rawdata,
                      date.name= "DATE",
                      date.format= "\%d/\%m/\%Y \%H:\%M",
                      timezone="GMT",
                      temperature.name="temperature")
                      
# then use incRenv to merge environmental data
new.data2 <- incRenv_old (data.nest = new.data,
                      data.env = incR_envdata, 
                      env.temperature.name = "env_temperature", 
                      env.date.name = "DATE", 
                      env.date.format = "\%d/\%m/\%Y \%H:\%M", 
                      env.timezone = "GMT")
                     
head (new.data2, 3)
}
\seealso{
\code{\link{incRprep}} \code{\link{incRscan}}
}
\author{
Pablo Capilla-Lasheras
}
