% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.differences.R
\name{vis.differences}
\alias{vis.differences}
\title{Visualize differences between Imputed Values and Real Values}
\usage{
vis.differences(ts.withNA, ts.withImpuations, ts.withTruth)
}
\arguments{
\item{ts.withNA}{Time Series (\code{\link{ts}}) object with NAs before imputation}

\item{ts.withImpuations}{Time Series (\code{\link{ts}}) object with NAs replaced by imputed values}

\item{ts.withTruth}{Time Series (\code{\link{ts}}) object containing the real values behind the NAs}
}
\description{
Visualize the differences between imputed values and real values to show performance of
imputation algorithm (only possible if NAs were artificially introduced and real values are known)
}
\examples{
#Load dataset
require(datasets)
data(AirPassengers)

#Dataset with the real values
airp.tru <- AirPassengers

#Create dataset with NAs
airp.na <- AirPassengers
airp.na[3:5] <- NA

#Perform imputation using na.mean
airp.imp <- na.mean(airp.na)

#Visualize difference between imputed and real values
vis.differences(airp.na, airp.imp, airp.tru)

}
\author{
Steffen Moritz
}

