% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/na.random.R
\name{na.random}
\alias{na.random}
\title{Missing Value Imputation by Random Sample}
\usage{
na.random(data, lowerBound = min(data, na.rm = T), upperBound = max(data,
  na.rm = T), na.identifier = NA)
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be removed}

\item{lowerBound}{Lower bound for the random samples (default is min(data) )}

\item{upperBound}{Upper bound for the random samples (default is max(data) )}

\item{na.identifier}{Missing Value Identifier.
If another value than NA indicates missing values this can be specified here.
Identifier can be a character string as well as a numeric value.}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Replaces each missing value by drawing a random sample between two given bounds.
}
\details{
Replaces each missing value by drawing a random sample bewteen two given bounds. The
default bounds are the minimum and the maximum value in the non-NAs from the time series. Funtion uses
\link{runif} function to get the random values.
}
\examples{
#Create Time series with missing values
x <- ts(c(2,3,NA,5,6,NA,7,8))

#Replace all NAs by random values between min and max of the inpute time series
na.random(x)

#Replace all NAs by random values between 1 and 10
na.random(x, lowerBound = 1, upperBound = 10)
}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.mean}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}}
}

