% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_caminos_descarga.R
\name{sig_caminos_descarga}
\alias{sig_caminos_descarga}
\title{Red Nacional de Caminos - Descarga datos}
\usage{
sig_caminos_descarga(year = NA)
}
\arguments{
\item{year}{Año de referencia del mapa, en formato numerico (2016-2019).}
}
\value{
Data.frame
}
\description{
Descarga un una lista con todos los mapas de la Red Nacional de Caminos para un año especifico. El objeto resultante de esta funcion es necesario para extraer, por separado, cada mapa con la funcion \code{sig_caminos_extrae()}.
}
\details{
La Red Nacional de Caminos (RNC) provee informacion georreferenciada sobre las vias de comunicacion inter-urbana e intra-urbana. Adicionalmente, contiene informacion sobre la infraestructura publica urbana (p. ej. tuneles, puentes, plazas de cobro, marcas de kilometraje, etc.), y la infraestructura de otros medios de transporte (p. ej. transbordadores, aeropuertos, puertos y estaciones de ferrocarril).
}
\examples{

# Descargar mapas de la RNC
\dontrun{mapas.rnc = sig_caminos_descarga(year = 2019)}
}
