% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo_poblacion_muestra.R
\name{censo_poblacion_muestra}
\alias{censo_poblacion_muestra}
\title{Censo de Poblacion - Muestra}
\usage{
censo_poblacion_muestra(year = 2010, estado = NA, muestra = NA)
}
\arguments{
\item{year}{Año del levantamiento del censo en formato numerico. Los años disponibles (incluyendo los conteos) son: 1990, 1995, 2005 y 2010.}

\item{estado}{Define el nombre de la entidad federativa para descargar los datos, en formato alfanumerico. Los nombres de los estados deben ir capitalizados (y en su caso, con espacios), por ejemplo: "Aguascalientes", "CDMX", "San Luis Potosi".}

\item{muestra}{Bases de datos disponibles \code{Migrantes} (1995, 2000 y 2010), \code{Personas} (1995, 2000, 2005 y 2010), \code{Viviendas} (2000, 2005 y 2010), \code{Hogar} (2005) y \code{NA} (1990).}
}
\value{
Data.frame
}
\description{
Censo de Poblacion y Vivienda. Muestra (cuestionario ampliado).
}
\details{
En la muestra del Censo la unidad de analisis puede ser personas, viviendas o migrantes. Por lo tanto, ademas del año y el estado, un tercer parametro requerido es \code{muestra}, que representa la unidad de analisis. Las unidades de analisis en este parámetro pueden ser \code{Migrantes}, \code{Personas}, \code{Viviendas} u \code{Hogar}.
}
\examples{

# Descarga los datos de CDMX de 2010.
\dontrun{muestra = censo_poblacion_muestra(year = 2010, estado = "CDMX", muestra = "Personas")}
}
