% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_impala.R
\name{copy_to}
\alias{copy_to}
\alias{copy_to.src_impala}
\title{Copy a (very small) local data frame to Impala}
\usage{
\method{copy_to}{src_impala}(dest, df, name = deparse(substitute(df)),
  types = NULL, temporary = TRUE, unique_indexes = NULL, indexes = NULL,
  analyze = TRUE, external = FALSE, overwrite = FALSE, force = FALSE,
  field_terminator = NULL, line_terminator = NULL, file_format = NULL,
  ...)
}
\arguments{
\item{dest}{an object with class with class \code{src_impala}}

\item{df}{a (very small) local data frame}

\item{name}{name for the new Impala table}

\item{types}{a character vector giving variable types to use for the columns}

\item{temporary}{must be set to \code{FALSE}}

\item{unique_indexes}{not used}

\item{indexes}{not used}

\item{analyze}{whether to run \code{COMPUTE STATS} after adding data to the
new table}

\item{external}{whether the new table will be externally managed}

\item{overwrite}{whether to overwrite existing table data (currently ignored)}

\item{force}{whether to silently continue if the table already exists}

\item{field_terminator}{the deliminter to use between fields in text file
data. Defaults to the ASCII control-A (hex 01) character}

\item{line_terminator}{the line terminator. Defaults to \code{"\n"}}

\item{file_format}{the storage format to use. Options are \code{"TEXTFILE"}
(default) and \code{"PARQUET"}}

\item{...}{other arguments passed on to methods}
}
\value{
An object with class \code{tbl_impala}, \code{tbl_sql},
  \code{tbl_lazy}, \code{tbl}
}
\description{
\code{copy_to} inserts the contents of a local data frame into a new Impala
table. \code{copy_to} currently only supports very small data frames (1000 or
fewer row/column positions). It uses the SQL \code{INSERT ... VALUES()}
technique, which is not suitable for loading large amounts of data.

This package does not provide tools for loading larger amounts of local data
into Impala tables. This is because Impala can query data stored in several
different filesystems and storage systems (HDFS, Apache Kudu, Apache HBase,
and Amazon S3) and Impala does not include built-in capability for loading
local data into these systems.
}
\note{
Impala does not support temporary tables. When using \code{copy_to()}
  to insert local data into an Impala table, you must set \code{temporary =
  FALSE}.
}
\examples{
library(nycflights13)
dim(airlines) # airlines data frame is very small
# [1] 16  2

\dontrun{
copy_to(impala, airlines, temporary = FALSE)}
}
