% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlayerIterationAverages.R
\name{getPlayerIterationAverages}
\alias{getPlayerIterationAverages}
\title{Return a dataframe that contains all player averages for a given iteration ID}
\usage{
getPlayerIterationAverages(iteration, token)
}
\arguments{
\item{iteration}{'IMPECT' iteration ID}

\item{token}{bearer token}
}
\value{
a dataframe containing the KPI averages aggregated per player and
position for the given iteration ID
}
\description{
Return a dataframe that contains all player averages for a given iteration ID
}
\examples{
# Toy example: this will error quickly (no API token)
try(player_avgs <- getPlayerIterationAverages(
  iteration = 0,
  token = "invalid"
))

# Real usage: requires valid Bearer Token from `getAccessToken()`
\dontrun{
player_avgs <- getPlayerIterationAverages(
  iteration = 1004,
  token = "yourToken"
)
}
}
