% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLstring_genes_expanded.R
\name{GLstring_genes_expanded}
\alias{GLstring_genes_expanded}
\title{GLstring_genes_expanded}
\usage{
GLstring_genes_expanded(data, gl_string)
}
\arguments{
\item{data}{A data frame containing GL strings for HLA data.}

\item{gl_string}{The name of the column in the data frame that contains
GL strings.}
}
\value{
A data frame with expanded columns, where each row has a single
allele for a specific locus.
}
\description{
This function processes a specified column in a data frame
that contains GL strings. It separates the GL strings, identifies the HLA
loci, and transforms the data into a wider format with loci as column names.
It also creates multiple rows to separate each locus in the allele.
}
\examples{

file <- HLA_typing_1[, -1]
GL_string <- data.frame("GL_string" = HLA_columns_to_GLstring(
  file,
  HLA_typing_columns = everything()
))
GL_string <- GL_string[1, , drop = FALSE] # When considering first patient
result <- GLstring_genes_expanded(GL_string, "GL_string")
print(result)

}
