% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLstring_expand_longer.R
\name{GLstring_expand_longer}
\alias{GLstring_expand_longer}
\title{GLstring_expand_longer}
\usage{
GLstring_expand_longer(GL_string)
}
\arguments{
\item{GL_string}{A GL string that encodes HLA alleles and their potential
ambiguities}
}
\value{
A tibble that contains the expanded GL string with separate columns
for possible gene locations, loci, genotype ambiguities, genotypes, haplotypes,
and alleles, each with associated identifiers
}
\description{
A function that expands a GL string into a longer, more detailed
format (also known as an ambiguity table) by separating the string into its
components resulting from its hierarchical set of operators, including gene
locations, loci, genotypes, haplotypes, and alleles. The function processes
each level of the GL string and assigns identifiers for each hierarchical
component. The resulting table can be assembled back into a GL string using
the function `ambiguity_table_to_GLstring`.
}
\examples{
file <- HLA_typing_1[, -1]
GL_string <- HLA_columns_to_GLstring(file, HLA_typing_columns = everything())
result <- GLstring_expand_longer(GL_string[1])
print(result)

}
