% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distance_transform}
\alias{distance_transform}
\title{Compute Euclidean distance function to a specified value.}
\usage{
distance_transform(im, value, metric = 2L)
}
\arguments{
\item{im}{an image}

\item{value}{Reference value.}

\item{metric}{Type of metric. Can be <tt>{ 0=Chebyshev | 1=Manhattan | 2=Euclidean | 3=Squared-euclidean }</tt>.}
}
\description{
The distance transform implementation has been submitted by A. Meijster, and implements
       the article 'W.H. Hesselink, A. Meijster, J.B.T.M. Roerdink,
                    "A general algorithm for computing distance transforms in linear time.",
                    In: Mathematical Morphology and its Applications to Image and Signal Processing,
                    J. Goutsias, L. Vincent, and D.S. Bloomberg (eds.), Kluwer, 2000, pp. 331-340.'
        The submitted code has then been modified to fit CImg coding style and constraints.
}
\examples{
imd <- function(x,y) imdirac(c(100,100,1,1),x,y)
#Image is three white dots
im <- imd(20,20)+imd(40,40)+imd(80,80)
plot(im)
#How far are we from the nearest white dot? 
distance_transform(im,1) \%>\% plot
}
