% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{displacement}
\alias{displacement}
\title{Estimate displacement field between two images.}
\usage{
displacement(
  sourceIm,
  destIm,
  smoothness = 0.1,
  precision = 5,
  nb_scales = 0L,
  iteration_max = 10000L,
  is_backward = FALSE
)
}
\arguments{
\item{sourceIm}{Reference image.}

\item{destIm}{Reference image.}

\item{smoothness}{Smoothness of estimated displacement field.}

\item{precision}{Precision required for algorithm convergence.}

\item{nb_scales}{Number of scales used to estimate the displacement field.}

\item{iteration_max}{Maximum number of iterations allowed for one scale.}

\item{is_backward}{If false, match I2(X + U(X)) = I1(X), else match I2(X) = I1(X - U(X)).}
}
\description{
Estimate displacement field between two images.
}
