% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{autocrop}
\alias{autocrop}
\title{Autocrop image region}
\usage{
autocrop(im, color = color.at(im, 1, 1), axes = "zyx")
}
\arguments{
\item{im}{an image}

\item{color}{Colour used for the crop. If missing, the colour is taken from the top-left pixel.}

\item{axes}{Axes used for the crop.}
}
\description{
Autocrop image region
}
\examples{
#Add pointless padding
padded <- pad(boats,30,"xy")
plot(padded)
#Remove padding
autocrop(padded) \%>\% plot

#autocrop has a zero-tolerance policy: if a pixel value is slightly different from the one you gave
#the pixel won't get cropped. A fix is to do a bucket fill first
padded <- isoblur(padded,10)
autocrop(padded) \%>\% plot
padded2 <- bucketfill(padded,1,1,col=c(0,0,0),sigma=.1)
autocrop(padded2) \%>\% plot
}
