% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canny.R
\name{cannyEdges}
\alias{cannyEdges}
\title{Canny edge detector}
\usage{
cannyEdges(im, t1, t2, alpha = 1, sigma = 2)
}
\arguments{
\item{im}{input image}

\item{t1}{threshold for weak edges (if missing, both thresholds are determined automatically)}

\item{t2}{threshold for strong edges}

\item{alpha}{threshold adjusment factor (default 1)}

\item{sigma}{smoothing}
}
\description{
If the threshold parameters are missing, they are determined automatically using a k-means heuristic. Use the alpha parameter  to adjust the automatic thresholds up or down
The thresholds are returned as attributes.
The edge detection is based on a smoothed image gradient with a degree of smoothing set by the sigma parameter.
}
\examples{
cannyEdges(boats) \%>\% plot
#Make thresholds less strict
cannyEdges(boats,alpha=.4) \%>\% plot
#Make thresholds more strict
cannyEdges(boats,alpha=1.4) \%>\% plot
}
\author{
Simon Barthelme
}

