% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pixset.R
\name{boundary}
\alias{boundary}
\title{Find the boundary of a shape in a pixel set}
\usage{
boundary(px, depth = 1, high_connexity = FALSE)
}
\arguments{
\item{px}{pixel set}

\item{depth}{boundary depth (default 1)}

\item{high_connexity}{if FALSE, use 4-point neighbourhood. If TRUE, use 8-point.  (default FALSE)}
}
\description{
Find the boundary of a shape in a pixel set
}
\examples{
px.diamond(10,30,30) \%>\% boundary \%>\% plot
px.square(10,30,30) \%>\% boundary \%>\% plot
px.square(10,30,30) \%>\% boundary(depth=3) \%>\% plot
px <- (px.square(10,30,30) | px.circle(12,30,30))
boundary(px,high=TRUE) \%>\% plot(int=TRUE,main="8-point neighbourhood")
boundary(px,high=TRUE) \%>\% plot(int=FALSE,main="4-point neighbourhood")
}

