% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{as.cimg}
\alias{as.cimg}
\alias{as.cimg.double}
\alias{as.cimg.matrix}
\alias{as.cimg.numeric}
\alias{as.cimg.vector}
\title{Convert to cimg object}
\usage{
as.cimg(obj, ...)

\method{as.cimg}{numeric}(obj, ...)

\method{as.cimg}{double}(obj, ...)

\method{as.cimg}{vector}(obj, x = NA, y = NA, z = NA, cc = NA, ...)

\method{as.cimg}{matrix}(obj, ...)
}
\arguments{
\item{obj}{an object}

\item{...}{optional arguments}

\item{x}{width}

\item{y}{height}

\item{z}{depth}

\item{cc}{spectrum}
}
\description{
Imager implements various converters that turn your data into cimg objects. If you convert from a vector (which only has a length, and no dimension), either specify dimensions explicitly or some guesswork will be involved. See examples for clarifications.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: convert numeric

\item \code{double}: convert double

\item \code{vector}: convert vector

\item \code{matrix}: 
}}
\examples{
as.cimg(1:100,x=10,y=10) #10x10, grayscale image
as.cimg(rep(1:100,3),x=10,y=10,cc=3) #10x10 RGB
as.cimg(1:100) #Guesses dimensions, warning is issued
as.cimg(rep(1:100,3)) #Guesses dimensions, warning is issued
}
\author{
Simon Barthelme
}
\seealso{
as.cimg.array, as.cimg.function, as.cimg.data.frame
}

