% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barplot.R
\docType{methods}
\name{add_row_barplot}
\alias{add_row_barplot}
\alias{add_row_barplot,Iheatmap-method}
\title{add_row_barplot}
\usage{
\S4method{add_row_barplot}{Iheatmap}(p, x, ..., color = NULL,
  tracename = NA_character_, showlegend = !is.na(tracename),
  side = c("right", "left"), layout = list(), size = 0.2,
  buffer = 0.02, xname = NULL, yname = current_yaxis(p), pname = if
  (!is.na(tracename)) tracename else "row_barplot")
}
\arguments{
\item{p}{iheatmap object}

\item{x}{x axis values}

\item{...}{additional arguments to add to plotly scatter trace, see
\url{https://plot.ly/javascript/reference/#scatter}}

\item{color}{color of bars}

\item{tracename}{name of trace (for legend and hover)}

\item{showlegend}{show in legend?}

\item{side}{side of plot on which to add subplot}

\item{layout}{yaxis layout list}

\item{size}{relative size of subplot relative to main heatmap}

\item{buffer}{amount of space to leave empty before this plot, relative to 
size of first heatmap}

\item{xname}{internal name of xaxis}

\item{yname}{internal name of yaxis}

\item{pname}{internal name of plot}
}
\value{
\code{\link{Iheatmap-class}} object, which can be printed to generate 
an interactive graphic
}
\description{
add_row_barplot
}
\examples{

mat <- matrix(rnorm(20), ncol = 5, nrow = 4)  
hm <- iheatmap(mat) \%>\% add_row_barplot(x = 1:4, tracename = "Strength")

# Print heatmap if interactive session 
if (interactive()) hm 
}
\seealso{
\code{\link{add_row_signal}}, \code{\link{iheatmap}}, 
\code{\link{add_row_plot}}
}
\author{
Alicia Schep
}
