% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{graph.dfs}
\alias{graph.dfs}
\title{Depth-first search}
\usage{
graph.dfs(
  graph,
  root,
  mode = c("out", "in", "all", "total"),
  unreachable = TRUE,
  order = TRUE,
  order.out = FALSE,
  father = FALSE,
  dist = FALSE,
  in.callback = NULL,
  out.callback = NULL,
  extra = NULL,
  rho = parent.frame(),
  neimode
)
}
\arguments{
\item{graph}{The input graph.}

\item{root}{The single root vertex to start the search from.}

\item{mode}{For directed graphs specifies the type of edges to follow.
\sQuote{out} follows outgoing, \sQuote{in} incoming edges. \sQuote{all}
ignores edge directions completely. \sQuote{total} is a synonym for
\sQuote{all}. This argument is ignored for undirected graphs.}

\item{unreachable}{Logical scalar, whether the search should visit the
vertices that are unreachable from the given root vertex (or vertices). If
\code{TRUE}, then additional searches are performed until all vertices are
visited.}

\item{order}{Logical scalar, whether to return the DFS ordering of the
vertices.}

\item{order.out}{Logical scalar, whether to return the ordering based on
leaving the subtree of the vertex.}

\item{father}{Logical scalar, whether to return the father of the vertices.}

\item{dist}{Logical scalar, whether to return the distance from the root of
the search tree.}

\item{in.callback}{If not \code{NULL}, then it must be callback function.
This is called whenever a vertex is visited. See details below.}

\item{out.callback}{If not \code{NULL}, then it must be callback function.
This is called whenever the subtree of a vertex is completed by the
algorithm. See details below.}

\item{extra}{Additional argument to supply to the callback function.}

\item{rho}{The environment in which the callback function is evaluated.}

\item{neimode}{This argument is deprecated from igraph 1.3.0; use
\code{mode} instead.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{graph.dfs()} was renamed to \code{dfs()} to create a more
consistent API.
}
\keyword{internal}
