% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{subgraph}
\alias{subgraph}
\alias{induced.subgraph}
\alias{subgraph.edges}
\alias{induced_subgraph}
\title{Subgraph of a graph}
\usage{
subgraph(graph, vids)

induced_subgraph(
  graph,
  vids,
  impl = c("auto", "copy_and_delete", "create_from_scratch")
)

subgraph.edges(graph, eids, delete.vertices = TRUE)
}
\arguments{
\item{graph}{The original graph.}

\item{vids}{Numeric vector, the vertices of the original graph which will
form the subgraph.}

\item{impl}{Character scalar, to choose between two implementation of the
subgraph calculation. \sQuote{\code{copy_and_delete}} copies the graph
first, and then deletes the vertices and edges that are not included in the
result graph. \sQuote{\code{create_from_scratch}} searches for all vertices
and edges that must be kept and then uses them to create the graph from
scratch. \sQuote{\code{auto}} chooses between the two implementations
automatically, using heuristics based on the size of the original and the
result graph.}

\item{eids}{The edge ids of the edges that will be kept in the result graph.}

\item{delete.vertices}{Logical scalar, whether to remove vertices that do
not have any adjacent edges in \code{eids}.}
}
\value{
A new graph object.
}
\description{
\code{subgraph()} creates a subgraph of a graph, containing only the specified
vertices and all the edges among them.
}
\details{
\code{induced_subgraph()} calculates the induced subgraph of a set of vertices
in a graph. This means that exactly the specified vertices and all the edges
between them will be kept in the result graph.

\code{subgraph.edges()} calculates the subgraph of a graph. For this function
one can specify the vertices and edges to keep. This function will be
renamed to \code{subgraph()} in the next major version of igraph.

The \code{subgraph()} function currently does the same as \code{induced_subgraph()}
(assuming \sQuote{\code{auto}} as the \code{impl} argument), but this behaviour
is deprecated. In the next major version, \code{subgraph()} will overtake the
functionality of \code{subgraph.edges()}.
}
\examples{

g <- make_ring(10)
g2 <- induced_subgraph(g, 1:7)
g3 <- subgraph.edges(g, 1:5, 1:5)

}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
