% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{running_mean}
\alias{running_mean}
\alias{running.mean}
\title{Running mean of a time series}
\usage{
running_mean(v, binwidth)
}
\arguments{
\item{v}{The numeric vector.}

\item{binwidth}{Numeric constant, the size of the bin, should be meaningful,
ie. smaller than the length of \code{v}.}
}
\value{
A numeric vector of length \code{length(v)-binwidth+1}
}
\description{
\code{running_mean()} calculates the running mean in a vector with the given
bin width.
}
\details{
The running mean of \code{v} is a \code{w} vector of length
\code{length(v)-binwidth+1}. The first element of \code{w} id the average of
the first \code{binwidth} elements of \code{v}, the second element of
\code{w} is the average of elements \code{2:(binwidth+1)}, etc.
}
\examples{

running_mean(1:100, 10)

}
\seealso{
Other other: 
\code{\link{convex_hull}()},
\code{\link{sample_seq}()},
\code{\link{srand}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{other}
\keyword{manip}
