% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_edgelist}
\alias{as_edgelist}
\alias{get.edgelist}
\title{Convert a graph to an edge list}
\usage{
as_edgelist(graph, names = TRUE)
}
\arguments{
\item{graph}{The graph to convert.}

\item{names}{Whether to return a character matrix containing vertex
names (ie. the \code{name} vertex attribute) if they exist or numeric
vertex ids.}
}
\value{
A \code{gsize(graph)} by 2 numeric matrix.
}
\description{
Sometimes it is useful to work with a standard representation of a
graph, like an edge list.
}
\details{
\code{as_edgelist} returns the list of edges in a graph.
}
\examples{

g <- sample_gnp(10, 2/10)
as_edgelist(g)

V(g)$name <- LETTERS[seq_len(gorder(g))]
as_edgelist(g)

}
\seealso{
\code{\link{graph_from_adjacency_matrix}}, \code{\link{read_graph}}
}
\keyword{graphs}
