% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/games.R
\name{sample_growing}
\alias{growing}
\alias{growing.random.game}
\alias{sample_growing}
\title{Growing random graph generation}
\usage{
sample_growing(n, m = 1, directed = TRUE, citation = FALSE)

growing(...)
}
\arguments{
\item{n}{Numeric constant, number of vertices in the graph.}

\item{m}{Numeric constant, number of edges added in each time step.}

\item{directed}{Logical, whether to create a directed graph.}

\item{citation}{Logical. If \code{TRUE} a citation graph is created, ie. in
each time step the added edges are originating from the new vertex.}

\item{...}{Passed to \code{sample_app}.}
}
\value{
A new graph object.
}
\description{
This function creates a random graph by simulating its stochastic evolution.
}
\details{
This is discrete time step model, in each time step a new vertex is added to
the graph and \code{m} new edges are created. If \code{citation} is
\code{FALSE} these edges are connecting two uniformly randomly chosen
vertices, otherwise the edges are connecting new vertex to uniformly
randomly chosen old vertices.
}
\examples{
g <- sample_growing(500, citation=FALSE)
g2 <- sample_growing(500, citation=TRUE)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{sample_pa}}, \code{\link{sample_gnp}}
}
\keyword{graphs}

