% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_as_star}
\alias{as_star}
\alias{layout.star}
\alias{layout_as_star}
\title{Generate coordinates to place the vertices of a graph in a star-shape}
\usage{
layout_as_star(graph, center = V(graph)[1], order = NULL)

as_star(...)
}
\arguments{
\item{graph}{The graph to layout.}

\item{center}{The id of the vertex to put in the center. By default it is
the first vertex.}

\item{order}{Numeric vector, the order of the vertices along the perimeter.
The default ordering is given by the vertex ids.}

\item{...}{Arguments to pass to \code{layout_as_star}.}
}
\value{
A matrix with two columns and as many rows as the number of vertices
in the input graph.
}
\description{
A simple layout generator, that places one vertex in the center of a circle
and the rest of the vertices equidistantly on the perimeter.
}
\details{
It is possible to choose the vertex that will be in the center, and the
order of the vertices can be also given.
}
\examples{
g <- make_star(10)
layout_as_star(g)

## Alternative form
layout_(g, as_star())
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{layout}} and \code{\link{layout.drl}} for other layout
algorithms, \code{\link{plot.igraph}} and \code{\link{tkplot}} on how to
plot graphs and \code{\link{star}} on how to create ring graphs.

Other graph layouts: \code{\link{add_layout_}};
  \code{\link{as_bipartite}},
  \code{\link{layout.bipartite}},
  \code{\link{layout_as_bipartite}}; \code{\link{as_tree}},
  \code{\link{layout_as_tree}};
  \code{\link{component_wise}}; \code{\link{in_circle}},
  \code{\link{layout_in_circle}};
  \code{\link{layout.auto}}, \code{\link{layout_nicely}},
  \code{\link{nicely}};
  \code{\link{layout.davidson.harel}},
  \code{\link{layout_with_dh}}, \code{\link{with_dh}};
  \code{\link{layout.gem}}, \code{\link{layout_with_gem}},
  \code{\link{with_gem}}; \code{\link{layout.graphopt}},
  \code{\link{layout_with_graphopt}},
  \code{\link{with_graphopt}}; \code{\link{layout.grid}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout.grid.3d}},
  \code{\link{layout_on_grid}}, \code{\link{on_grid}};
  \code{\link{layout.mds}}, \code{\link{layout_with_mds}},
  \code{\link{with_mds}}; \code{\link{layout.merge}},
  \code{\link{layout_components}},
  \code{\link{merge_coords}},
  \code{\link{piecewise.layout}},
  \code{\link{piecewise.layout}};
  \code{\link{layout.norm}}, \code{\link{norm_coords}};
  \code{\link{layout.sugiyama}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{with_sugiyama}};
  \code{\link{layout_on_sphere}}, \code{\link{on_sphere}};
  \code{\link{layout_randomly}}, \code{\link{randomly}};
  \code{\link{layout_with_fr}}, \code{\link{with_fr}};
  \code{\link{layout_with_kk}}, \code{\link{with_kk}};
  \code{\link{layout_with_lgl}}, \code{\link{with_lgl}};
  \code{\link{layout}}, \code{\link{layout_}},
  \code{\link{print.igraph_layout_modifier}},
  \code{\link{print.igraph_layout_spec}};
  \code{\link{normalize}}
}
\keyword{graphs}

