% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/iterators.R
\name{as_ids}
\alias{as_ids}
\alias{as_ids.igraph.es}
\alias{as_ids.igraph.vs}
\title{Convert a vertex or edge sequence to an ordinary vector}
\usage{
as_ids(seq)

\method{as_ids}{igraph.vs}(seq)

\method{as_ids}{igraph.es}(seq)
}
\arguments{
\item{seq}{The vertex or edge sequence.}
}
\value{
A character or numeric vector, see details below.
}
\description{
Convert a vertex or edge sequence to an ordinary vector
}
\details{
For graphs without names, a numeric vector is returned, containing the
internal numeric vertex or edge ids.

For graphs with names, and vertex sequences, the vertex names are
returned in a character vector.

For graphs with names and edge sequences, a character vector is
returned, with the \sQuote{bar} notation: \code{a|b} means an edge from
vertex \code{a} to vertex \code{b}.
}
\examples{
g <- make_ring(10)
as_ids(V(g))
as_ids(E(g))

V(g)$name <- letters[1:10]
as_ids(V(g))
as_ids(E(g))
}

