% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_irishgridrefs.R
\name{st_irishgridrefs}
\alias{st_irishgridrefs}
\title{Generate Irish grid references from an sf object}
\usage{
st_irishgridrefs(x, digits = 3, precision = NULL, sep = "")
}
\arguments{
\item{x}{An sf object containing geometries of type POINT.}

\item{digits}{An integer, the number of digits for both easting and northing
in the Irish grid references.
\itemize{
\item \code{0}: equivalent to a precision of 100 km.
\item \code{1}: equivalent to a precision of 10 km.
\item \code{2}: equivalent to a precision of 1 km.
\item \code{3} (the default): equivalent to a precision of 100 m.
\item \code{4}: equivalent to a precision of 10 m.
\item \code{5}: equivalent to a precision of 1 m.
}}

\item{precision}{An integer, the precision of the Irish grid references in
metres: \code{1}, \code{10}, \code{100}, \code{1000}, \code{2000}, \code{10000}, or \code{100000}. Overrides
\code{digits}. Use \code{2000} to produce the tetrad form of Irish grid reference.}

\item{sep}{A character string to place between the 100 km grid letter,
easting, northing, and tetrad.}
}
\value{
A character vector of Irish grid references.
}
\description{
\code{st_irishgridrefs()} returns the Irish grid references for all features in an
sf object of point geometries. Features located outside the Irish Grid
(EPSG:29903) extent are returned as NA.
}
\examples{
# An sf object containing point data
x_sf <- sf::st_as_sf(data.frame(x = c(0, 490000), y = c(400000, 0)),
  crs = 29903,
  coords = c("x", "y")
)

# Convert to Irish grid references
st_irishgridrefs(x_sf)

# Convert into Irish grid references with 4 digit easting and northing (10 m precision)
st_irishgridrefs(x_sf, digits = 4)

# Convert into Irish grid references with 1 km precision (2 digit easting and northing)
st_irishgridrefs(x_sf, precision = 1000)

# Convert into Irish grid references with 2 km precision (tetrad form)
st_irishgridrefs(x_sf, precision = 2000)

# Insert a space between the 100 km grid letter, easting, and northing
st_irishgridrefs(x_sf, sep = " ")
}
