% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimized_iglu_functions.R
\name{optimized_iglu_functions}
\alias{optimized_iglu_functions}
\title{Optimized Calculations of Time Dependent iglu Metrics}
\usage{
optimized_iglu_functions(data)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}
}
\value{
If a data.frame object is passed, then a tibble object with 1 row for each subject
and one column for each metric is returned.
}
\description{
The function optimized_iglu_functions optimizes the calculation of all time dependent iglu
metrics by extracting the CGMS2DayByDay calculation and passing the result into each function.
}
\details{
Returns a tibble object with 1 row for each subject and a column for each metric. This
function includes time dependent iglu metrics only. For metric specific information,
please see the corresponding function documentation.
}
\examples{
data(example_data_1_subject)
optimized_iglu_functions(example_data_1_subject)

data(example_data_5_subject)
optimized_iglu_functions(example_data_5_subject)

}
